/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.AttributesUtil;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReachEnchant
extends EnchantmentCyclic {
    private static final String NBT_REACH_ON = "reachon";
    public static final int REACH_BOOST = 11;
    public static final String ID = "reach";
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final UUID ENCHANTMENT_REACH_ID;

    public ReachEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        if (this.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 1;
    }

    private void turnReachOff(Player player) {
        player.getPersistentData().m_128379_(NBT_REACH_ON, false);
        AttributesUtil.removePlayerReach(ENCHANTMENT_REACH_ID, player);
    }

    private void turnReachOn(Player player) {
        player.getPersistentData().m_128379_(NBT_REACH_ON, true);
        AttributesUtil.setPlayerReach(ENCHANTMENT_REACH_ID, player, 11);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        ItemStack armor = this.getFirstArmorStackWithEnchant((LivingEntity)player);
        int level = 0;
        if (!armor.m_41619_() && EnchantmentHelper.m_44831_((ItemStack)armor) != null && EnchantmentHelper.m_44831_((ItemStack)armor).containsKey((Object)this)) {
            level = (Integer)EnchantmentHelper.m_44831_((ItemStack)armor).get((Object)this);
        }
        if (level > 0) {
            this.turnReachOn(player);
        } else if (player.getPersistentData().m_128441_(NBT_REACH_ON) && player.getPersistentData().m_128471_(NBT_REACH_ON)) {
            this.turnReachOff(player);
        }
    }

    static {
        ENCHANTMENT_REACH_ID = UUID.fromString("1abcdef2-eff2-4a81-b92b-a1cb95f115c6");
    }
}

